package easik.states;

import easik.Easik;

/**
 * This state is used when adding elements to the graph so that the selection
 * algorithm does not insert then in weird places.
 * 
 * @author Kevin Green 2006
 * @since 2006-07-13 Kevin Green
 * @version 2006-07-13 Kevin Green
 */
public class LoadingState extends EasikState {
		
	/**
	 * There is nowhere to go from basic editing (state-wise) so when it is pushed
	 * on, it disables Next and Cancel.
	 */
	public void pushedOn() {
		this.setCancelButton(false);
		this.setNextButton(false);		
	}

	/**
	 * Empty method, as this should never be popped off. 
	 */
	public void poppedOff() {	
		Easik.getInstance().getFrame().getSketch().clearSelection();
	}
	
	/**
	 * Used to identify this class.
	 * 
	 * @return String literal "Basic Editing"
	 */
	public String toString() {
		return "Loading";
	}
}
